import com.xebialabs.restito.server.StubServer;

import static com.xebialabs.restito.builder.stub.StubHttp.whenHttp;
import static com.xebialabs.restito.semantics.Action.*;
import static com.xebialabs.restito.semantics.Condition.*;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public class MviServices {
    public static void main(String[] args) throws Exception {

        StubServer server = new StubServer(8093).run();

        whenHttp(server).match(alwaysTrue())
        .then(contentType("text/xml"), resourceContent("mvi-id-not-found.soap"));

        whenHttp(server).match(endsWithUri("/mockVAIdMPort"), withPostBodyContaining("PATID59^NI^200DOD^USDOD"))
                .then(contentType("text/xml"), resourceContent("zztest_patient59_mvi-null.soap"));

        whenHttp(server).match(endsWithUri("/mockVAIdMPort"), withPostBodyContaining("P011^NI^200DOD^USDOD"))
                .then(contentType("text/xml"), resourceContent("patient_eleven_single_dfn.soap"));

        whenHttp(server).match(endsWithUri("/mockVAIdMPort"), withPostBodyContaining("P004^NI^200DOD^USDOD"))
                .then(contentType("text/xml"), resourceContent("patient_four_multiple_dfn.soap"));

        whenHttp(server).match(endsWithUri("/mockVAIdMPort"), withPostBodyContaining("D123401^NI^200DOD^USDOD"))
        .then(contentType("text/xml"), resourceContent("zztest_patient01_signle_dfn.soap"));

        whenHttp(server).match(endsWithUri("/mockVAIdMPort"), withPostBodyContaining("0000000008^NI^200DOD^USDOD"))
                .then(contentType("text/xml"), resourceContent("zztest_patient10_no_site_double_dfn.soap"));

        whenHttp(server).match(endsWithUri("/mockVAIdMPort"), withPostBodyContaining("0000000014^NI^200DOD^USDOD"))
                .then(contentType("text/xml"), resourceContent("zztest_patient14_single_dfn.soap"));

        whenHttp(server).match(endsWithUri("/mockVAIdMPort"), withPostBodyContaining("0000000003^NI^200DOD^USDOD"))
                .then(contentType("text/xml"), resourceContent("zztest_patient51_single_dfn.soap"));

        whenHttp(server).match(endsWithUri("/mockVAIdMPort"), withPostBodyContaining("0000000001^NI^200DOD^USDOD"))
                .then(contentType("text/xml"), resourceContent("zztest_patient66_double_dfn.soap"));

        while (true) { Thread.sleep(10000); }
    }
}
